/*
COPYRIGHT INFORMATION:
This free script was written by Daniel Rodney - instructor, graphic designer
Adobe Certified Expert
Adobe Certified Instructor
No part of this script can be used and/or redistributed as your own.
All rights are reserved by Daniel Rodney.
http://www.danrodney.com
dan@danrodney.com
Copyright Daniel Rodney 2005-2007

DESCRIPTION:
This script is meant to provide a fast way to convert numerous typographer's quotes (smart quotes) 
into foot and inch marks all at once. I hope you find it useful and a time saver.

You can share this script with friends and associates as long as it does not involve posting 
it on a website or other medium where it can be downloaded/shared with many people. 
Any form of mass distribution is prohibited unless you obtain prior written consent. 
Please direct people to http://www.danrodney.com to download it.

Thanks Dan!
If you find this "free" script valuable, please consider making a donation via PayPal. It will:
- Encourage me to write more free scripts.
- Make you (and me) feel warm and fuzzy inside.
- Be a great way to say thanks for the hours I spent writing a script that saved you some time and effort.
Just visit http://www.danrodney.com/scripts
Go to the Quotes to Foot & Inch Marks page and click the Make A Donation button. Thanks!

COMPATIBILITY:
This script works on both Mac and PC. It has been tested in InDesign/InCopy CS3.

INSTRUCTIONS - INSTALLING THE SCRIPT:
To install the script, put the script file (has a .js file extension) into the folder listed below. 
(InCopy installations are identical to InDesign, except the desired folder is titled InCopy.)

CS2 & CS: Mac-----------------------------------------------------------
Hard Drive > Applications > Adobe InDesign CS2 (or CS) > Presets > Scripts

CS2 & CS: Windows-----------------------------------------------------------
C:Drive > Program Files > Adobe > Adobe InDesign CS2 (or CS) > Presets > Scripts

INSTRUCTIONS - USING THE SCRIPT:
1. Select some text that contains typographers quotes you would like to change into foot/inch marks.
2. Double-click this script's name in the Scripts palette.
          NOTE: To find the Scripts palette:
          In InDesign CS2: Go into the Window menu and choose Automation > Scripts.
          In InDesign CS:  Go into the Window menu and choose Scripting > Scripts.
That's it! I hope you enjoy... 


==================================================================================================  */

//start of the actual script

//define function to reuse whenever they don't haven't the proper text selected
function myQuoteTextNotSelectedAlert()
{
	alert("Please select some text that contains quotes you would like to convert.\nScript written by Daniel Rodney - instructor, graphic designer\nwww.danrodney.com");
}

if (app.documents.length == 0) //make sure a document is open
{
	//no documents are open, so display an error message
	alert("You don't have any InDesign documents open. Please open a document and select some text that contains quotes you would like to convert.\nScript written by Daniel Rodney - instructor, graphic designer\nwww.danrodney.com");
}
else if (app.selection.length == 0) //make sure something is selected
{
	//nothing is selected, so display an error message
	myQuoteTextNotSelectedAlert();
}
else if (app.selection.length > 1) //make sure only one thing is selected
{
	//more than one thing is selected, so display an error message
	alert("Please select only one text frame that contains quotes you would like to convert.\nScript written by Daniel Rodney - instructor, graphic designer\nwww.danrodney.com");
}
else if (app.selection[0].constructor.name == "InsertionPoint") //make sure text is selected
{
	//no text is selected, so display an error message
	myQuoteTextNotSelectedAlert();
}
else if (app.selection[0].contents == undefined) //make sure it's text that is selected
{
	//nothing is selected, so display an error message
	myQuoteTextNotSelectedAlert();
}
else
{
	//find out the current document's Typographers Quote Preference
	userOriginalQuotePreference = app.activeDocument.textPreferences.typographersQuotes

	//turn off the Typographers preference
	app.activeDocument.textPreferences.typographersQuotes = false
	
	//set Find/Change preferences to nothing, in case the user had left settings on a previous search
	app.findPreferences = NothingEnum.nothing
	app.changePreferences = NothingEnum.nothing

	//====================== PERFORM SEARCHES  ======================
	app.selection[0].search("\u201C", false, false, "\u0022" )	//change left double quote into inch mark
	app.selection[0].search("\u201D", false, false, "\u0022" )	//change right double quote into inch mark
	app.selection[0].search("\u2018", false, false, "\u0027" )	//change left single quote into foot mark
	app.selection[0].search("\u2019", false, false, "\u0027" )	//change right single quote into foot mark
	
	//reset Typographers Quote Preference back to the users original setting
	app.activeDocument.textPreferences.typographersQuotes = userOriginalQuotePreference;	
}